#version 330

uniform sampler2DArray texArray;
#if GRASS
uniform sampler2D groundNoise;
uniform sampler2D fadeNoise;
uniform vec4 invGroundNoiseSize;
#endif
#if !ASG_SPECULAR
uniform vec4 specular;
#endif
#if GBUFFER
uniform float farClip;
#else
uniform vec4 lightPosition;
uniform vec4 ambient;
#endif

in vec4 pos;
in vec3 norm;
in vec2 uv;
in vec3 idx;
#if NORMAL_MAP
in vec3 tang;
in vec3 binorm;
#endif
#if VERTEX_COLOR
in vec4 vcolor;
#endif
#if GRASS
in vec4 worldPos;
#endif

#if GBUFFER
out vec4 oColor0;
out vec4 oColor1;
#else
out vec4 oColor;
#endif

#if NORMAL_MAP
vec3 expand(vec2 v) {
	vec3 nor;
	nor.xy = v*2.0 - 1.0;
	nor.z = sqrt(1.0 - dot(nor.xy, nor.xy));
	return nor;
}
#endif

vec2 encodeNormal(vec3 n)
{
    float p = sqrt(n.z*8 + 8);
    return vec2(n.xy/p + 0.5);
}

void main() 
 {
	vec2 dx = dFdx(uv.xy);
	vec2 dy = dFdy(uv.xy);
	
	float color0w = 0.0;
	float specI = 0.0;
	
#if (GRASS && VERTEX_COLOR)
	if(textureLod(fadeNoise, worldPos.xy, 0).r - vcolor.a < 0.25) discard;
#endif

	vec4 diffuse = textureGrad(texArray, vec3(uv.xy, idx.x), dx, dy);
	
#if (ASG_ALPHA || ASG_SPECULAR)
	vec3 asg = textureGrad(texArray, vec3(uv.xy, idx.z), dx, dy).rgb;
#endif

#if ASG_ALPHA
	if(asg.r < 0.5) discard;
#else
	#if DIF_ALPHA
		#if GRASS
			if(diffuse.a < 0.2) discard;
		#else
			if(diffuse.a < 0.5) discard;
		#endif
	#endif
#endif

#if VERTEX_COLOR
	#if DIF_ALPHA
		diffuse.rgb *= vcolor.rgb;
	#else
		diffuse.rgb = mix(vcolor.rgb, diffuse.rgb, diffuse.a);
	#endif
#endif

#if ASG_SPECULAR
	specI = asg.g;
#else
	specI = specular.r;
#endif
	
#if ASG_SPECULAR
	if(asg.b > 0.0) {
		color0w = 4.0 + (0.99608*asg.b);
	}
#endif
#if GRASS
	color0w = 2.0 + (0.99608 - clamp(worldPos.z + 0.75, 0.0, 0.99608));
	diffuse *= textureLod(groundNoise, worldPos.xy*invGroundNoiseSize.xy*0.25, 0)*0.5 + 0.5;
#endif

#if NORMAL_MAP
	#if FLIP_BACK_NORMALS
		vec3 N_ts = expand(textureGrad(texArray, vec3(uv.xy, idx.y), dx, dy).ag);
		N_ts *= gl_FrontFacing ? vec3(-1.0, -1.0, 1.0) : vec3(1.0, 1.0, 1.0);
		vec3 N = normalize(tang*N_ts.x + binorm*N_ts.y + norm*N_ts.z);
		N *= gl_FrontFacing ? -1.0 : 1.0;
	#else
		vec3 N_ts = expand(textureGrad(texArray, vec3(uv.xy, idx.y), dx, dy).ag);
		vec3 N = normalize(tang*N_ts.x + binorm*N_ts.y + norm*N_ts.z);
	#endif
#else
	#if FLIP_BACK_NORMALS
		vec3 N = normalize(gl_FrontFacing ? -norm : norm);
	#else
		vec3 N = normalize(norm);
	#endif
#endif

#if GBUFFER
	oColor0 = vec4(encodeNormal(N), pos.z/farClip, color0w);
	oColor1 = vec4(diffuse.rgb, specI);
#else
	vec3 LightDir = normalize(lightPosition.xyz); //Direction pointing towards light source
	float NdotL = dot(LightDir, N);
	vec3 EyeDir = normalize(-pos.xyz);
	float Rim = pow(1 - abs(dot(EyeDir, N)), 2)*0.5;
	vec3 HalfAngle = normalize(LightDir + EyeDir);
	float NdotH = dot(HalfAngle, N);
	vec4 Lit = vec4(1.0, max(NdotL, 0.0), (NdotL > 0) ? pow(max(0.0, NdotH), 73.1707) : 0, 1.0);
	
	oColor = vec4(clamp(diffuse.rgb*(ambient.rgb + vec3(Lit.y)) + vec3(specI*(Lit.z + Rim)), 0.0, 1.0), 1.0);
#endif
}
 